# Data Science Learning Resources

Welcome to the **Data Science Learning Resources** repository! Here, you'll find a curated list of resources organized from beginner to advanced levels. Whether you're just starting out or looking to advance your skills, these resources will guide you through the journey of becoming a proficient Data Scientist.

## 📑 Table of Contents
1. [Beginner Level](#-beginner-level)
2. [Tools and Resources](#️-tools-and-resources)
3. [Contribute](#-contribute)

---

## 🟢 Beginner Level

### 🧠 What is Data Science?
Data science is a field that uses scientific methods, algorithms, and systems to gain insights from both organized and unorganized data. It combines math, statistics, specialized programming, advanced analytics, AI, and machine learning with specific domain knowledge to uncover actionable information in an organization’s data. These insights support decision-making and strategic planning.

### Who is a Data Scientist?
A data scientist works with data to understand and explain different phenomena, helping organizations make better decisions. Their work often overlaps with data analysts, especially in exploring and visualizing data. However, data scientists generally have a broader skillset, using programming languages like R and Python to perform deeper statistical analysis and data visualization.

### Courses & Tutorials:
- [**Statistics**](https://youtube.com/watch?v=XZo4xyJXCak&list=PL0o_zxa4K1BVsziIRdfv4Hl4UIqDZhXWV) - **Statistics**: Introduction to Statistics.
- [**Charts**](https://365datascience.com/trending/chart-types-and-how-to-select-the-right-one/) - **365 Data Science**: Types of Charts.
- [**Excel for Beginners**](https://w3schools.com/excel/) - **W3Schools**: Excel Tutorials.
- [**SQL for Beginners**](https://w3schools.com/sql/) - **W3Schools**: SQL Tutorials.
- [**Python**](https://datacamp.com/) - **DataCamp**: Python Basics.
- [**Introduction to Data Science**](https://youtu.be/ua-CiDNNj30?si=Mi_vu5JZT95h30la) - **FreeCodeCamp - Youtube**: Introduction to mindfulness and meditation.
- [**Exploratory Data Analysis**](https://geeksforgeeks.com/what-is-exploratory-data-analysis/) - **Geeksforgeeks**: What is Explanatory Data Analysis?

### Key Concepts:
- [**Data**](https://tutorialspoint.com/computer_fundamentals/computer_data.htm) - Computer Fundamentals: Data and Information.
- [**Data Preparation**](https://datacamp.com/) - Data preparation with pandas.
- [**Data Visualisation**](https://datacamp.com/) - Understanding Data Visualisation Course.
- [**Machine Learning Algorithms**](https://datacamp.com/) - Machine learning.
- [**Data Storytelling**](https://datacamp.com/) - Data Storytelling Concepts.

---

## ⚒️ Tools and Resources

Enhance your data science journey with these essential tools and platforms.

- [**Python**](https://python.org/downloads/) - A high-level programming language.
- [**Anaconda**](https://anaconda.com/download) - A distribution of the Python and R programming languages for scientific compting which includes Jupyter notebook.
- [**Microsoft Excel**](https://microsoft.com/excel) - A spreadsheet editor
- [**Google Sheets**](https://docs.google.com/spreadsheets) - A web-based spreadsheet editor.
- [**MySQL**](https://mysql.com/downloads/) - A Relational Database Management System.
- [**Big Query**](https://console.cloud.google.com/bigquery) - An online platform that can be used for SQL.
- [**Google Colab**](https://colab.research.google.com/) - A hosted jupyter notebook service.
- [**Numpy**](https://numpy.org/doc/) - A Python Library (Numerical Python).
- [**Pandas**](https://pandas.pydata.org/docs/) - A data analysis and manipulation tool, built on Python.
- [**Matplotlib**](https://matplotlib.org/stable/index.html) - A library for creating static, animated and interactive visualisations in Python.
- [**Seaborn**](https://seaborn.pydata.org/) - A Python data visualisation library based on Matplotlib.
- [**Scikit-learn**](https://scikit-learn.org/) - Maching learning in Python.

---

## 🤝 Contribute

Want to add a resource? Contributions are welcome! Please check out the [CONTRIBUTING.md](./CONTRIBUTING.md) file for guidelines on how to contribute.

---

Feel free to explore and share with your community! 🚀

[Introduction]: #-introduction